#Nun schauen wir uns einen Beispieldatensatz an 
#nehmen wir an, wir würden dieses Skript als erstes starten
#dann müssten zunaechst alle Packages geladen werden, die wir benoetigen

library(tidyverse)

#naechster Schritt: Daten importieren
#gehen sie ueber die Menüleiste zu import Dataset zu from text(readr) und 
#importieren sie den File oder geben sie den Code mit entsprechendem Pfad ein:
Beispieldatensatz <- read_csv("C:/..../Beispieldatensatz.txt")

test <- Beispieldatensatz
#wir erstellen eine Kopie des Beispieldatensatzes, damit wir nicht mit dem
#originalen Datensatz arbeiten müssen

View(test)
#so koennen wir uns den Datensatz anschauen

summary(test)
# wir erhalten eine Zusammenfassung der Spalten, bei integer-Werten mit
# Mittelwert etc.

head(test)
#gibt uns die ersten Zeilen wieder

str(test)
#fasst tiefergehende Informationen zu dem Dataset zusammen, 
#sind auch rechts in der Uebersicht zu sehen

names(test)
# gibt uns eine Uebersicht der Spaltentitel und somit eine Uebersicht, 
# ob man etwas aendern sollte 

#SemesterAnzahlAbschluss ist mir z.B. zu lang, ich nenne es in Fachsemester um: 
names(test)[names(test) == "SemesteranzahlAbschluss"] <- "Fachsemester"

#kuerzer geht es über die Indexwerte
names(test)
colnames(test)

names(test)[5] <- "Fachsemester"

#nun ueberpruefen wir, ob es fehlende Werte gibt
any(is.na(test$Fachsemester))
any(is.na(test$Haustier))
#in diesem Fall wurde bei "Haustier" teilweise keine Werte angegeben, weil
#die Personen keine haben, wir nennen sie also in "keins" um

test[is.na(test)] <- "Keins"
#wenn man Folgendes praeferieren würde: 
na.omit(test)  #so werden alle NAs entfernt

#wir überpruefen, ob es geklappt hat
any(is.na(test))

View(test)

#man kann sich auch eine Übersicht der jeweiligen Verteilung anzeigen lassen
table(test$Haustier)
      

#da wir mit einem Datenset arbeiten, teilen wir RStudio mit, dass wir immer
#die zugehoerigen Objekte von dem Datenset "test" meinen, damit man nicht so viel schreiben muss
attach(test)
#trennen kann man es mit detach()

#es lohnt sich immer, die Daten genau anzuschauen
table(Haustier)
table(Geschlecht)
table(Augenfarbe)
table(Fach)
table(Fachsemester)

#da Fachsemester eine Zahl ist, werden hier auch Mittelwert etc. angegeben
range(Fachsemester)
min(Fachsemester)
max(Fachsemester)
quantile(Fachsemester, seq(from=0, to=1, by=0.2))
mean(Fachsemester)
median(Fachsemester)

#wir koennen uns die Daten aber auch grafisch anzeigen lassen
barplot(table(Fachsemester), main="Fachsemesterverteilung", xlab="Semesteranzahl bis Abschluss", ylab="Anzahl Studierende", col=7)
boxplot(Fachsemester, main="Fachsemesterverteilung", xlab="Semesteranzahl bis Abschluss", ylab="Anzahl Studierende", col=5)
plot(Fachsemester, main="Fachsemesterverteilung", xlab="Anzahl Studierende", ylab="Anzahl Semester", type="l", pch=1, lwd=1, cex=.5, col="black")

#die Zusammenhaenge zwischen zweier Variablen lassen sich auch anzeigen

table(Geschlecht, Fachsemester)
table(Fachsemester, Haustier)
table(Fachsemester, Haustier!="Keins")
#das muss natuerlich auch sinnvoll sein, was man da abfragt; die Maschine kann 
#nicht alles leisten

test1 <- test

#wir können aber auch Datensets mit nur einer Ausprägung anlegen und so vergleichen
w <- subset(test1, test1$Geschlecht=="w") 
m <- subset(test1, test1$Geschlecht=="m")
d <- subset(test1, test1$Geschlecht=="d")
View(w)

barplot(table(w$Fachsemester), main="Fachsemesterverteilung", xlab="Semesteranzahl bis Abschluss", ylab="Anzahl Studierenden", col=5)
mean(w$Fachsemester)
mean(m$Fachsemester)
mean(d$Fachsemester)

#man kann auch Grafiken übereinander legen: 
plot(w$Fachsemester, main="Fachsemesterverteilung", xlab="Anzahl Semester", ylab="Anzahl Studierenden",xlim=c(0,25),ylim=c(4,25), type="l", lwd=4, cex=.5, col="5")
par(new=TRUE)
plot(m$Fachsemester, main="Fachsemesterverteilung", xlab="Anzahl Semester", ylab="Anzahl Studierenden",xlim=c(0,25), ylim=c(4,25), type="l", lwd=4, cex=.5, col="6")
par(new=TRUE)
plot(d$Fachsemester, main="Fachsemesterverteilung", xlab="Anzahl Semester", ylab="Anzahl Studierenden",xlim=c(0,25), ylim=c(4, 25), type="l", lwd=4, cex=.5, col="7")


#eine Alternative neben subset ist group_by
#sollte man nicht tidyverse geladen haben, muss man dafür zugehörige packages laden
library(magrittr)
library(dplyr)
test1 %>% group_by(Geschlecht)
test2 <- test1 %>% group_by(Geschlecht) %>% mutate(Geschlecht="w") %>% filter(Fachsemester>10)


test1$Fach[test1$Fach %in% c("Mathe","Physik","Biochemie", "Bioinformatik", "Biophysik", "Biologie", "Chemie", "Informatik", "Umwelt", "Medizin", "Wirtschaft")] <- "Mint"
test1$Fach[!test1$Fach %in% c("Mint")] <- "Geist"
View(test1)

mean(test1$Fachsemester[test1$Fach=="Mint"])

mean(test1$Fachsemester[test1$Fach=="Geist"])

View(test1)
