#!/bin/bash

TARGET=~/Schreibtisch/Eingang/
PROCESSED=~/Schreibtisch/Ausgang/

inotifywait -m -e create -e moved_to --format "%f" $TARGET \
        | while read FILENAME
                do
			if [[ $FILENAME == *.odt ]]; then
				echo Detected $FILENAME -> Converting
				NAME=${FILENAME%.odt}
				OUTPUTDIR="$PROCESSED/$NAME"
				if [ ! -d "$OUTPUTDIR" ]; then
					mkdir "$OUTPUTDIR"
				fi
				pandoc --standalone --to latex -o "$OUTPUTDIR/$NAME.tex" "$TARGET/$FILENAME"
				pandoc --standalone --to html -o "$OUTPUTDIR/$NAME.html" "$TARGET/$FILENAME"
				pandoc --standalone --to latex -o "$OUTPUTDIR/$NAME.pdf" "$TARGET/$FILENAME"
                        	mv "$TARGET/$FILENAME" "$OUTPUTDIR/$FILENAME"
			fi
                done
