#!/bin/bash

function cutImage {
        
        # Ignore directories
        if [ -d "$1" ]; then
            exit 0
        fi

        f="$1"
        echo "Processing $f"
        parentname="$(dirname "$(dirname "$f")")"
        filename="${f##*/}"
        cutJpgFile="$parentname/$filename"
        jp2filename="${cutJpgFile/.jpg/.jp2}"
        
        # Cut the file
        ../Scripts/multicrop2 -b "gray(60)" -f 25 -d 700000 "$f" "$cutJpgFile" 

        # Check if the multicrop2 command exited successfully
        if [ $? -eq 0 ]; then
            # Transfer to JPG2000 and reduce file size
            # The input file name has to be adapted because the 'multicrop2' script appends a '-000' before the suffix
            cutJpgFile="${cutJpgFile/.jpg/-000.jpg}"
        else
            echo "Multicrop did not work on file $f"
            # The image cannot be transformed. So, copy it to the parent folder and convert it only to JP2
            # Transfer to JPG2000 and reduce file size
  #          convert "$f" -quality 100 -define jpeg:extent=1000kb "$jp2filename"
        fi
}

# Get number of cores
cpus=$(getconf _NPROCESSORS_ONLN)

export -f cutImage

# Find all folders names 'original' and then all jpg files within theses.
find . -type d -name original -exec find "{}" -name \*.jpg \; | xargs --max-args=1 --max-procs=$cpus -I {} bash -c 'cutImage "{}"'
