#!/bin/bash

# Konstanten
SUCHBEGRIFF=$1
OUTPUTDIR=${3:-"./script-output"}
EINGABEVERZEICHNIS=${2:-"."}

# Suche alle Dateien mit dem Inhalt "Arbeit"
DATEIEN=`grep -ril --include \*.pdf $SUCHBEGRIFF $EINGABEVERZEICHNIS/*`

# Pruefe ob Dateien gefunden wurden. Stoppe Script, falls nicht.
if [ -z "$DATEIEN" ]; then
	echo "Keine Dateien gefunden!"
	exit
fi

# Iteriere ueber Dateien
for datei in $DATEIEN
do
	# Extrahiere Dateinamen und haenge ein "txt" an.
	dateiName=${datei##*/}
	dateiName=${dateiName%pdf}txt

	# Erstelle das Ausgabeverzeichnis, falls es noch nicht existiert.
	if [ ! -d $OUTPUTDIR  ]; then
		mkdir $OUTPUTDIR
	fi

	# Kopiere den Inhalt der gefundenen Datei in die neue Datei.
	less $datei > $OUTPUTDIR/$dateiName
done
